<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
<#if sys.codeName == 'Sample'>
package ${pub.getPKGCodeName()}.util.service;

import ${pub.getPKGCodeName()}.util.annotation.ValueRuleCheck;
import ${pub.getPKGCodeName()}.util.domain.DTOBase;
import ${pub.getPKGCodeName()}.util.domain.ValueRule;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.ObjectUtils;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.HashMap;
import java.util.Map;

public class ValueRuleValidator implements ConstraintValidator<ValueRuleCheck, DTOBase> {

    private static Map<String, ValueRule> sysRule = new HashMap<>();

    private final ExpressionParser parser = new SpelExpressionParser();

    private String field;

    private String ruleName;

    @Override
    public void initialize(ValueRuleCheck constraintAnnotation) {
        this.field = constraintAnnotation.field();
        this.ruleName = constraintAnnotation.rule();
    }

    @Override
    public boolean isValid(DTOBase dto, ConstraintValidatorContext context) {
        if (!ObjectUtils.isEmpty(dto) && !ObjectUtils.isEmpty(ruleName) && !ObjectUtils.isEmpty(sysRule.get(ruleName)) && !ObjectUtils.isEmpty(dto.get(field))) {
            ValueRule rule = sysRule.get(ruleName);
            String ruleCond = rule.getCond();
            String ruleMessage = rule.getMessage();
            EvaluationContext searchContextCtx = new StandardEvaluationContext();
            searchContextCtx.setVariable("dto", dto);
            Expression searchContextExp = parser.parseExpression(ruleCond);
            boolean isValid = searchContextExp.getValue(searchContextCtx, Boolean.class);
            if (!isValid) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(String.format("执行[%s]属性[%s]值规则发生异常，%s", field, ruleName, ruleMessage))
                        .addConstraintViolation();
                return false;
            }
        }
        return true;
    }

    static {
        <#if sys.getAllPSDataEntities()??>
            <#list sys.getAllPSDataEntities() as de>
                <#if de.getAllPSDEFValueRules()??>
                <#list de.getAllPSDEFValueRules() as deRule>
                    <#if deRule.codeName!='Default'>
                        <#if deRule.getPSDEFVRGroupCondition()??>
                            <#assign group=deRule.getPSDEFVRGroupCondition()>
                            <#assign ruleName=(de.codeName+"_"+deRule.getPSDEField().codeName+"_"+deRule.codeName)?lower_case>
                            <#assign ruleCond=getGroupCond(group)>
                            <#assign ruleMessage=getGroupMessage(group)>
                            <#if ruleCond!="">
        sysRule.put("${ruleName}", new ValueRule("${ruleCond}","${ruleMessage}"));
                            </#if>
                        </#if>
                    </#if>
                </#list>
                </#if>
            </#list>
        </#if>

    }

}
</#if>

<#comment>获取组条件表达式</#comment>
<#function getGroupCond group>
    <#assign strRuleCond="">
    <#if group.getPSDEFVRConditions()??>
        <#assign condOp=group.getCondOp()?replace("AND","&&")?replace("OR","||")>
        <#list group.getPSDEFVRConditions() as childRule>
            <#assign childRuleType=childRule.getCondType()>
            <#if childRuleType=='GROUP'>
                <#assign strRuleCond=strRuleCond+getGroupCond(childRule)>
            <#else>
                <#assign strRuleCond=strRuleCond+getFieldCond(childRule)>
            </#if>
            <#if childRule_has_next>
                <#assign strRuleCond=strRuleCond+condOp>//拼接连接符
            </#if>
        </#list>
    </#if>
    <#if strRuleCond!="">
        <#assign strRuleCond="("+strRuleCond+")">
    </#if>
    <#return strRuleCond/>
</#function>

<#comment>获取单项条件表达式</#comment>
<#function getFieldCond fieldRule>
    <#assign childRuleType=fieldRule.getCondType()>
    <#assign fieldCond="(" >
    <#assign condBody="1==1">
    <#comment>常规规则</#comment>
    <#if childRuleType=='SIMPLE'>
        <#assign targetFieldName=fieldRule.getDEFName()><#comment>目标属性名称</#comment>
        <#assign targetDEField=((de.getPSDEField(targetFieldName,true))!'')><#comment>目标属性</#comment>
        <#assign targetDBValueOP=fieldRule.getCondOp()><#comment>表达式</#comment>
        <#assign targetValue=((fieldRule.getParamValue())!'')><#comment>值项</#comment>
        <#if targetDEField!=''>
            <#assign targetFieldName=srfcaseformat(targetDEField.codeName,'l_u2lC')>
        </#if>
        <#assign condBody="T(${pub.getPKGCodeName()}.util.helper.RuleUtils).test(#dto.get(\\\""+targetFieldName+"\\\"),\\\""+targetDBValueOP+"\\\","+"\\\""+targetValue+"\\\")">
    </#if>
    <#assign fieldCond=fieldCond+condBody >
    <#assign fieldCond=fieldCond+")" >
    <#return fieldCond/>
</#function>

<#comment>获取group规则信息</#comment>
<#function getGroupMessage group>
    <#assign ruleMessage="(">
    <#if group.getPSDEFVRConditions()??>
        <#assign op=group.getCondOp()?replace("AND","并且")?replace("OR","或者")>
        <#list group.getPSDEFVRConditions() as childRule>
            <#assign childRuleType=childRule.getCondType()>
            <#if childRuleType=='GROUP'>
                <#assign ruleMessage=ruleMessage+getGroupMessage(childRule)>
            <#else>
                <#assign ruleMessage=ruleMessage+getFieldMessage(childRule)>
            </#if>
            <#if childRule_has_next>
                <#assign ruleMessage=ruleMessage+op>
            </#if>
        </#list>
    </#if>
    <#assign ruleMessage=ruleMessage+")">
    <#return ruleMessage/>
</#function>

<#comment>获取field规则信息</#comment>
<#function getFieldMessage fieldRule>
    <#assign fieldMessage="">
    <#if fieldRule.getRuleInfo?? && fieldRule.getRuleInfo()??>
        <#assign fieldMessage=fieldRule.getRuleInfo()>
    </#if>
    <#return fieldMessage/>
</#function>